Attribute VB_Name = "FEUSB"
'  ---------------------------------------------------------
'  |                                                       |
'  |                      FEUSB.BAS                        |
'  |                                                       |
'  ---------------------------------------------------------
'
'Copyright  2000-2005  FEIG ELECTRONIC GmbH, All Rights Reserved.
'                       Lange Strasse 4
'                       D-35781 Weilburg
'                       Federal Republic of Germany
'                       phone    : +49 6471 31090
'                       fax      : +49 6471 310999
'                       e-mail   : info@feig.de
'                       Internet : http://www.feig.de
'
'Version              : 02.03.02 / 04.07.2005 / M. Hultsch
'
'Operation Systems    : Windows 98/ME/2000/XP
'
'
'This File contains the constants, datatypes and function declarations of FEUSB.DLL

Option Explicit

' constants for uiFlag in FEUSB_MSG_INIT
Public Const FEUSB_THREAD_ID = 1        'not useable in Visual Basic
Public Const FEUSB_WND_HWND = 2         'not useable in Visual Basic
Public Const FEUSB_CALLBACK = 3

' defines for uiUse in FEUSB_EVENT_INIT
Public Const FEUSB_DEV_CONNECT_EVENT = 1
Public Const FEUSB_DEV_DISCONNECT_EVENT = 2

' scan options
Public Const FEUSB_SCAN_FIRST = &H1
Public Const FEUSB_SCAN_NEXT = &H2
Public Const FEUSB_SCAN_NEW = &H3
Public Const FEUSB_SCAN_ALL = &HF
Public Const FEUSB_SCAN_SEARCH = &H10000
Public Const FEUSB_SCAN_PACK = &H20000

' search options
Public Const FEUSB_SEARCH_FAMILY = &H1
Public Const FEUSB_SEARCH_PRODUCT = &H2
Public Const FEUSB_SEARCH_DEVICEID = &H4

' communication directions
Public Const FEUSB_DIR_IN = 1
Public Const FEUSB_DIR_OUT = 2

' Interface names
Public Const FEUSB_INTERFACE_OBID_RCI = "OBID-RCI"
Public Const FEUSB_INTERFACE_OBID_RCI_V2 = "OBID-RCI2"


' structure for transfering callback functions
Type FEUSB_EVENT_INIT
        uiUse   As Long         ' defines the event (e.g. FEUSB_DEV_CONNECT_EVENT)
        uiMsg   As Long         ' set always to 0 - in Visual Basic not used !!
        uiFlag  As Long         ' specifies the use of the Variant (e.g. FEUSB_CALLBACK)
        Method  As Long         ' for callback-function
End Type

' new datatype
Type FEUSB_SCANSEARCH
        iMask           As Long
        cFamily         As String * 25
        cProduct        As String * 25
        cInterface      As String * 25
        cDeviceID       As String * 9
End Type

        

' common functions
Public Declare Sub FEUSB_GetDLLVersion Lib "FEUSB.DLL" (ByVal cVersion As String)
Public Declare Function FEUSB_GetErrorText Lib "FEUSB.DLL" (ByVal iError As Long, ByVal cText As String) As Long
Public Declare Function FEUSB_GetLastError Lib "FEUSB.DLL" (ByVal iDevHnd As Long, iErrorCode As Long, ByVal cErrorText As String) As Long

' scan functions
Public Declare Function FEUSB_Scan Lib "FEUSB.DLL" (ByVal iScanOpt As Long, SearchOpt As FEUSB_SCANSEARCH) As Long
Public Declare Function FEUSB_ScanAndOpen Lib "FEUSB.DLL" (ByVal iScanOpt As Long, SearchOpt As FEUSB_SCANSEARCH) As Long
Public Declare Function FEUSB_GetScanListPara Lib "FEUSB.DLL" (ByVal iIndex As Long, ByVal cPara As String, ByVal cValue As String) As Long
Public Declare Function FEUSB_GetScanListSize Lib "FEUSB.DLL" () As Long
Public Declare Sub FEUSB_ClearScanList Lib "FEUSB.DLL" ()

' functions for event notification
Public Declare Function FEUSB_AddEventHandler Lib "FEUSB.DLL" (ByVal iPortHnd As Long, pInit As FEUSB_EVENT_INIT) As Long
Public Declare Function FEUSB_DelEventHandler Lib "FEUSB.DLL" (ByVal iPortHnd As Long, pInit As FEUSB_EVENT_INIT) As Long

' device functions
Public Declare Function FEUSB_OpenDevice Lib "FEUSB.DLL" (ByVal dwDeviceID As Long) As Long
Public Declare Function FEUSB_CloseDevice Lib "FEUSB.DLL" (ByVal iDevHnd As Long) As Long
Public Declare Function FEUSB_IsDevicePresent Lib "FEUSB.DLL" (ByVal iDevHnd As Long) As Long
Public Declare Function FEUSB_GetDeviceList Lib "FEUSB.DLL" (ByVal iNext As Long) As Long
Public Declare Function FEUSB_GetDeviceHnd Lib "FEUSB.DLL" (ByVal dwDeviceID As Long) As Long
Public Declare Function FEUSB_GetDevicePara Lib "FEUSB.DLL" (ByVal iDeviceHnd As Long, ByVal cParaID As String, ByVal cValue As String) As Long
Public Declare Function FEUSB_SetDevicePara Lib "FEUSB.DLL" (ByVal iDeviceHnd As Long, ByVal cParaID As String, ByVal cValue As String) As Long

' communication function
Public Declare Function FEUSB_Transceive Lib "FEUSB.DLL" (ByVal iDevHnd As Long, ByVal cInterface As String, ByVal iDir As Long, ByVal cSendData As String, ByVal iSendLen As Long, ByVal cRecData As String, ByVal iRecLen As Long) As Long
Public Declare Function FEUSB_Transmit Lib "FEUSB.DLL" (ByVal iDevHnd As Long, ByVal cInterface As String, ByVal cSendData As String, ByVal iSendLen As Long) As Long
Public Declare Function FEUSB_Receive Lib "FEUSB.DLL" (ByVal iDevHnd As Long, ByVal cInterface As String, ByVal cRecData As String, ByVal iRecLen As Long) As Long

